/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SlayerStyleArts {
    static final EnumSet<InputCommand> fowerd_sprint_sneak = EnumSet.of(InputCommand.FORWARD, InputCommand.SPRINT, InputCommand.SNEAK);
    static final EnumSet<InputCommand> back_sprint_sneak = EnumSet.of(InputCommand.BACK, InputCommand.SPRINT, InputCommand.SNEAK);
    static final EnumSet<InputCommand> move = EnumSet.of(InputCommand.FORWARD, InputCommand.BACK, InputCommand.LEFT, InputCommand.RIGHT);
    public static final ResourceLocation ADVANCEMENT_AIR_TRICK = new ResourceLocation("slashblade", "abilities/air_trick");
    public static final ResourceLocation ADVANCEMENT_TRICK_DOWN = new ResourceLocation("slashblade", "abilities/trick_down");
    public static final ResourceLocation ADVANCEMENT_TRICK_DODGE = new ResourceLocation("slashblade", "abilities/trick_dodge");
    public static final ResourceLocation ADVANCEMENT_TRICK_UP = new ResourceLocation("slashblade", "abilities/trick_up");
    static final int TRICKACTION_UNTOUCHABLE_TIME = 10;
    static final float stepUpBoost = 1.1f;
    static final float stepUpDefault = 0.6f;

    public static SlayerStyleArts getInstance() {
        return SingletonHolder.instance;
    }

    private SlayerStyleArts() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        final ServerPlayer sender = event.getEntity();
        Level worldIn = sender.m_9236_();
        ItemStack stack = sender.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        if (!old.contains((Object)InputCommand.SPRINT)) {
            boolean isHandled = false;
            if (current.containsAll(fowerd_sprint_sneak)) {
                isHandled = sender.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
                    Entity tmpTarget = state.getTargetEntity(worldIn);
                    Object target = tmpTarget != null && tmpTarget.getParts() != null && tmpTarget.getParts().length > 0 ? tmpTarget.getParts()[0] : tmpTarget;
                    if (target == null && 0 == sender.getPersistentData().m_128451_("sb.avoid.trickup")) {
                        Untouchable.setUntouchable((LivingEntity)sender, 10);
                        Vec3 motion = new Vec3(0.0, 0.8, 0.0);
                        sender.m_6478_(MoverType.SELF, motion);
                        sender.f_8927_ = true;
                        sender.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(sender.m_19879_(), motion.m_82490_(0.75)));
                        sender.getPersistentData().m_128405_("sb.avoid.trickup", 2);
                        sender.m_6853_(false);
                        sender.getPersistentData().m_128405_("sb.avoid.counter", 2);
                        NBTHelper.putVector3d(sender.getPersistentData(), "sb.avoid.vec", sender.m_20182_());
                        AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_UP);
                        sender.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 1.2f);
                        return true;
                    }
                    if (target != null) {
                        if (target == sender.m_21214_() && sender.f_19797_ < sender.m_21215_() + 100) {
                            LivingEntity hitEntity = sender.m_21214_();
                            if (hitEntity != null) {
                                SlayerStyleArts.doTeleport((Entity)sender, hitEntity);
                            }
                        } else {
                            EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword((EntityType)SlashBlade.RegistryEvents.SummonedSword, worldIn, (Entity)target){
                                final /* synthetic */ Entity val$target;
                                {
                                    this.val$target = entity;
                                    super((EntityType<? extends Projectile>)entityTypeIn, worldIn);
                                }

                                @Override
                                protected void m_5790_(EntityHitResult p_213868_1_) {
                                    super.m_5790_(p_213868_1_);
                                    LivingEntity target = sender.m_21214_();
                                    if (target != null && this.getHitEntity() == target) {
                                        SlayerStyleArts.doTeleport((Entity)sender, target);
                                    }
                                }

                                @Override
                                public void m_8119_() {
                                    if (this.getPersistentData().m_128471_("doForceHit")) {
                                        this.doForceHitEntity(this.val$target);
                                        this.getPersistentData().m_128473_("doForceHit");
                                    }
                                    super.m_8119_();
                                }
                            };
                            Vec3 lastPos = sender.m_20299_(1.0f);
                            ss.f_19790_ = lastPos.f_82479_;
                            ss.f_19791_ = lastPos.f_82480_;
                            ss.f_19792_ = lastPos.f_82481_;
                            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0).m_82549_(sender.m_20154_().m_82490_(-2.0));
                            ss.m_6034_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                            Vec3 dir = sender.m_20154_();
                            ss.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 1.0f, 0.0f);
                            ss.m_5602_((Entity)sender);
                            ss.setDamage(0.01f);
                            ss.setColor(state.getColorCode());
                            ss.getPersistentData().m_128379_("doForceHit", true);
                            worldIn.m_7967_((Entity)ss);
                            sender.m_6330_(SoundEvents.f_11757_, SoundSource.PLAYERS, 0.2f, 1.45f);
                        }
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            if (!isHandled && !sender.m_20096_() && current.containsAll(back_sprint_sneak)) {
                Vec3 oldpos = sender.m_20182_();
                Vec3 motion = new Vec3(0.0, -5.0, 0.0);
                sender.m_6478_(MoverType.SELF, motion);
                if (sender.m_20096_()) {
                    Untouchable.setUntouchable((LivingEntity)sender, 10);
                    sender.f_8927_ = true;
                    sender.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(sender.m_19879_(), motion.m_82490_(0.75)));
                    sender.getPersistentData().m_128405_("sb.avoid.counter", 2);
                    NBTHelper.putVector3d(sender.getPersistentData(), "sb.avoid.vec", sender.m_20182_());
                    AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_DOWN);
                    sender.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 1.2f);
                    isHandled = true;
                } else {
                    sender.m_146884_(oldpos);
                }
            }
            if (!isHandled && sender.m_20096_() && current.contains((Object)InputCommand.SPRINT) && current.stream().anyMatch(cc -> move.contains(cc))) {
                Level level = sender.m_9236_();
                int count = sender.getCapability(CapabilityMobEffect.MOB_EFFECT).map(ef -> ef.doAvoid(level.m_46467_())).orElse(0);
                if (0 < count) {
                    float moveForward;
                    Untouchable.setUntouchable((LivingEntity)sender, 10);
                    float f = current.contains((Object)InputCommand.FORWARD) == current.contains((Object)InputCommand.BACK) ? 0.0f : (moveForward = current.contains((Object)InputCommand.FORWARD) ? 1.0f : -1.0f);
                    float moveStrafe = current.contains((Object)InputCommand.LEFT) == current.contains((Object)InputCommand.RIGHT) ? 0.0f : (current.contains((Object)InputCommand.LEFT) ? 1.0f : -1.0f);
                    Vec3 input = new Vec3((double)moveStrafe, 0.0, (double)moveForward);
                    sender.m_19920_(3.0f, input);
                    Vec3 motion = this.maybeBackOffFromEdge(sender.m_20184_(), (LivingEntity)sender);
                    sender.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 1.2f);
                    sender.m_6478_(MoverType.SELF, motion);
                    sender.f_8927_ = true;
                    sender.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(sender.m_19879_(), motion.m_82490_(0.5)));
                    sender.getPersistentData().m_128405_("sb.avoid.counter", 2);
                    NBTHelper.putVector3d(sender.getPersistentData(), "sb.avoid.vec", sender.m_20182_());
                    AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_DODGE);
                    sender.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.updateComboSeq((LivingEntity)sender, state.getComboRoot()));
                }
                isHandled = true;
            }
        }
    }

    private static void doTeleport(Entity entityIn, LivingEntity target) {
        entityIn.getPersistentData().m_128405_("sb.airtrick.counter", 3);
        entityIn.getPersistentData().m_128405_("sb.airtrick.target", target.m_19879_());
        if (entityIn instanceof ServerPlayer) {
            AdvancementHelper.grantCriterion((ServerPlayer)entityIn, ADVANCEMENT_AIR_TRICK);
            Vec3 motion = target.m_20318_(1.0f).m_82546_(entityIn.m_20318_(1.0f)).m_82490_(0.5);
            ((ServerPlayer)entityIn).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entityIn.m_19879_(), motion));
        }
    }

    private static void executeTeleport(Entity entityIn, LivingEntity target) {
        if (!(entityIn.m_9236_() instanceof ServerLevel)) {
            return;
        }
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.75f, 1.25f);
            player.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.updateComboSeq((LivingEntity)player, state.getComboRoot()));
            Untouchable.setUntouchable((LivingEntity)player, 10);
        }
        ServerLevel worldIn = (ServerLevel)entityIn.m_9236_();
        Vec3 tereportPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0).m_82549_(entityIn.m_20154_().m_82490_(-2.0));
        double x = tereportPos.f_82479_;
        double y = tereportPos.f_82480_;
        double z = tereportPos.f_82481_;
        float yaw = entityIn.m_146908_();
        float pitch = entityIn.m_146909_();
        Set relativeList = Collections.emptySet();
        BlockPos blockpos = new BlockPos((int)x, (int)y, (int)z);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            return;
        }
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityIn;
            ChunkPos chunkpos = new ChunkPos(blockpos);
            worldIn.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)entityIn.m_19879_());
            entityIn.m_8127_();
            if (serverPlayer.m_5803_()) {
                serverPlayer.m_6145_(true, true);
            }
            if (worldIn == entityIn.m_9236_()) {
                serverPlayer.f_8906_.m_9780_(x, y, z, yaw, pitch, relativeList);
            } else {
                serverPlayer.m_8999_(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.m_5616_(yaw);
        } else {
            float f1 = Mth.m_14177_((float)yaw);
            float f = Mth.m_14177_((float)pitch);
            f = Mth.m_14036_((float)f, (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.m_9236_()) {
                entityIn.m_7678_(x, y, z, f1, f);
                entityIn.m_5616_(f1);
            } else {
                entityIn.m_19877_();
                Entity entity = entityIn;
                entityIn = entityIn.m_6095_().m_20615_((Level)worldIn);
                if (entityIn == null) {
                    return;
                }
                entityIn.m_20361_(entity);
                entityIn.m_7678_(x, y, z, f1, f);
                entityIn.m_5616_(f1);
            }
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).m_21255_()) {
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entityIn.m_6853_(false);
        }
        if (entityIn instanceof PathfinderMob) {
            ((PathfinderMob)entityIn).m_21573_().m_26573_();
        }
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 vec, LivingEntity mover) {
        double d0 = vec.f_82479_;
        double d1 = vec.f_82481_;
        while (d0 != 0.0 && mover.m_9236_().m_45756_((Entity)mover, mover.m_20191_().m_82386_(d0, (double)(-mover.m_274421_()), 0.0))) {
            if (d0 < 0.05 && d0 >= -0.05) {
                d0 = 0.0;
                continue;
            }
            if (d0 > 0.0) {
                d0 -= 0.05;
                continue;
            }
            d0 += 0.05;
        }
        while (d1 != 0.0 && mover.m_9236_().m_45756_((Entity)mover, mover.m_20191_().m_82386_(0.0, (double)(-mover.m_274421_()), d1))) {
            if (d1 < 0.05 && d1 >= -0.05) {
                d1 = 0.0;
                continue;
            }
            if (d1 > 0.0) {
                d1 -= 0.05;
                continue;
            }
            d1 += 0.05;
        }
        while (d0 != 0.0 && d1 != 0.0 && mover.m_9236_().m_45756_((Entity)mover, mover.m_20191_().m_82386_(d0, (double)(-mover.m_274421_()), d1))) {
            d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
            if (d1 < 0.05 && d1 >= -0.05) {
                d1 = 0.0;
                continue;
            }
            if (d1 > 0.0) {
                d1 -= 0.05;
                continue;
            }
            d1 += 0.05;
        }
        vec = new Vec3(d0, vec.f_82480_, d1);
        return vec;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        switch (event.phase) {
            case START: {
                Vec3 deltaMovement;
                float stepUp = event.player.m_274421_();
                Player player = event.player;
                Vec3 input = new Vec3((double)player.f_20900_, (double)player.f_20901_, (double)player.f_20902_);
                double scale = 1.0;
                float yRot = player.m_146908_();
                double d0 = input.m_82556_();
                if (d0 < 1.0E-7) {
                    deltaMovement = Vec3.f_82478_;
                } else {
                    Vec3 vec3 = (d0 > 1.0 ? input.m_82541_() : input).m_82490_(scale);
                    float f = Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
                    float f1 = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
                    deltaMovement = new Vec3(vec3.f_82479_ * (double)f1 - vec3.f_82481_ * (double)f, vec3.f_82480_, vec3.f_82481_ * (double)f1 + vec3.f_82479_ * (double)f);
                }
                boolean doStepupBoost = true;
                if (doStepupBoost) {
                    Vec3 offset = deltaMovement.m_82541_().m_82490_(0.5).m_82520_(0.0, 0.25, 0.0);
                    BlockPos offsetedPos = new BlockPos(VectorHelper.f2i(player.m_20182_().m_82549_(offset))).m_7495_();
                    BlockState blockState = player.m_9236_().m_8055_(offsetedPos);
                    if (blockState.m_278721_()) {
                        doStepupBoost = false;
                    }
                }
                if (doStepupBoost && event.player.m_21205_().m_41720_() instanceof ItemSlashBlade && stepUp < 1.1f) {
                    event.player.getPersistentData().m_128350_("sb.store.stepup", stepUp);
                    event.player.m_274367_(1.1f);
                }
                if (event.player.m_20096_() && 0 < event.player.getPersistentData().m_128451_("sb.avoid.trickup")) {
                    int count = event.player.getPersistentData().m_128451_("sb.avoid.trickup");
                    if (--count <= 0) {
                        event.player.getPersistentData().m_128473_("sb.avoid.trickup");
                        if (event.player instanceof ServerPlayer) {
                            ((ServerPlayer)event.player).m_8959_();
                        }
                    } else {
                        event.player.getPersistentData().m_128405_("sb.avoid.trickup", count);
                    }
                }
                if (event.player.getPersistentData().m_128441_("sb.avoid.counter")) {
                    int count = event.player.getPersistentData().m_128451_("sb.avoid.counter");
                    if (--count <= 0) {
                        if (event.player.getPersistentData().m_128441_("sb.avoid.vec")) {
                            Vec3 pos = NBTHelper.getVector3d(event.player.getPersistentData(), "sb.avoid.vec");
                            event.player.m_20219_(pos);
                        }
                        event.player.getPersistentData().m_128473_("sb.avoid.counter");
                        event.player.getPersistentData().m_128473_("sb.avoid.vec");
                        if (event.player instanceof ServerPlayer) {
                            ((ServerPlayer)event.player).m_8959_();
                        }
                    } else {
                        event.player.getPersistentData().m_128405_("sb.avoid.counter", count);
                    }
                }
                if (!event.player.getPersistentData().m_128441_("sb.airtrick.counter")) break;
                int count = event.player.getPersistentData().m_128451_("sb.airtrick.counter");
                if (--count <= 0) {
                    if (event.player.getPersistentData().m_128441_("sb.airtrick.target")) {
                        int id = event.player.getPersistentData().m_128451_("sb.airtrick.target");
                        Entity target = event.player.m_9236_().m_6815_(id);
                        if (target != null && target instanceof LivingEntity) {
                            SlayerStyleArts.executeTeleport((Entity)event.player, (LivingEntity)target);
                        }
                    }
                    event.player.getPersistentData().m_128473_("sb.airtrick.counter");
                    event.player.getPersistentData().m_128473_("sb.airtrick.target");
                    if (!(event.player instanceof ServerPlayer)) break;
                    ((ServerPlayer)event.player).m_8959_();
                    break;
                }
                event.player.getPersistentData().m_128405_("sb.airtrick.counter", count);
                break;
            }
            case END: {
                float stepUp = event.player.getPersistentData().m_128457_("sb.tmp.stepup");
                stepUp = Math.max(stepUp, 0.6f);
                if (!(stepUp < event.player.m_274421_())) break;
                event.player.m_274367_(stepUp);
            }
        }
    }

    private static final class SingletonHolder {
        private static final SlayerStyleArts instance = new SlayerStyleArts();

        private SingletonHolder() {
        }
    }
}

